"""
メインモジュール

    「ちょこっとストップウォッチ」
    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.config import Config

import constants

Config.set("graphics", "width", constants.WIDTH)
Config.set("graphics", "height", constants.HEIGHT)
# Config.set("graphics", "minimum_width", 300)
# Config.set("graphics", "minimum_height", 80)
Config.set("graphics", "resizable", False)
Config.set("input", "mouse", "mouse, disable_multitouch")
Config.set("kivy", "exit_on_escape", "0")
# Config.set("modules", "showborder", "")from kivy.app import App

import kivy  # noqa
import kivy.resources  # noqa
from kivy.app import App  # noqa
from kivy.core.text import LabelBase, DEFAULT_FONT  # noqa
from kivy.core.window import Window  # noqa

from my_config import MyConfig  # noqa
from my_utilities import helper, json_io  # noqa
from constants import PRODUCT_NAME  # noqa
from root_widget import RootWidget  # noqa


class MainApp(App):
    def __init__(self, **kwargs) -> None:
        super().__init__(**kwargs)

        kivy.resources.resource_add_path(helper.get_resource_path("images"))
        kivy.resources.resource_add_path(helper.get_resource_path("fonts"))
        LabelBase.register(DEFAULT_FONT, "TakaoPGothic.ttf")

        self.title = PRODUCT_NAME
        self.icon = "favicon.ico"

        self._config: MyConfig = self._get_config_values()
        """アプリの設定値等を管理するクラスのインスタンス"""

        Window.top = self._config.window_pos_top
        Window.left = self._config.window_pos_left
        Window.always_on_top = self._config.always_on_top

    def build(self) -> RootWidget:
        return RootWidget(self._config)

    def on_stop(self):
        """アプリを終了したとき。"""

        self._config.window_pos_left = Window.left
        self._config.window_pos_top = Window.top
        self._config.always_on_top = Window.always_on_top

        self._output_config_values()

    def _get_config_values(self) -> MyConfig:
        """
        設定ファイルからアプリの設定値を読み込み、MyConfig のインスタンスに
        格納して返す。ファイルが存在しない場合は、既定値が格納された MyConfig の
        インスタンスを返す。

        Returns:
            MyConfig: 設定値が格納された MyConfig のインスタンス。
        """

        file_path: str = constants.CONF_FILE_PATH

        try:
            my_config: MyConfig = json_io.load_dataclass(MyConfig(), file_path)

        except Exception:
            my_config = MyConfig()

        return my_config

    def _output_config_values(self) -> None:
        """アプリの設定値を設定ファイルに出力する。"""

        file_path: str = constants.CONF_FILE_PATH

        try:
            json_io.output_dataclass(self._config, file_path)

        except Exception:
            pass


if __name__ == "__main__":
    MainApp().run()
