"""
エントリーポイント

    「ロト6 当せん数字予測アプリ」
    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

import os
import sys

if hasattr(sys, "_MEIPASS"):
    os.environ["KIVY_NO_CONSOLELOG"] = "1"

from kivy.config import Config

Config.set("graphics", "width", 800)
Config.set("graphics", "height", 600)
Config.set("graphics", "minimum_width", 800)
Config.set("graphics", "minimum_height", 600)
# Config.set("graphics", "resizable", False)
Config.set("input", "mouse", "mouse, disable_multitouch")
Config.set("kivy", "exit_on_escape", "0")
# Config.set("modules", "showborder", "")

import kivy  # noqa
import kivy.resources  # noqa
import polars as pl  # noqa
from kivy.app import App  # noqa
from kivy.core.text import DEFAULT_FONT, LabelBase  # noqa

import constants  # noqa
from my_utilities import helper  # noqa
from shared_vars import SharedVars  # noqa
from views import root_widget  # noqa

kivy.resources.resource_add_path(helper.get_resource_path("images"))
kivy.resources.resource_add_path(helper.get_resource_path("fonts"))

# ベースフォントの設定
LabelBase.register(DEFAULT_FONT, "VL-PGothic-Regular.ttf")


class MainApp(App):
    use_kivy_settings = False

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

        self.title = constants.PRODUCT_NAME
        self.icon = "favicon.ico"

        self._shared_vars: SharedVars = SharedVars()

    def build(self):
        root = root_widget.RootWidget(self._shared_vars)
        return root

    def on_stop(self):
        """アプリを終了するとき。"""

        df: pl.DataFrame = self._shared_vars.df
        df.write_parquet(constants.PARQUET_PATH, compression="zstd")


if __name__ == "__main__":
    MainApp().run()
