"""
選択可能な RecycleBoxLayout の定義

    Last modified: 2025/06/24

    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from datagrid.row_item import RowItem
from kivy.properties import ObjectProperty
from kivy.uix.behaviors import FocusBehavior
from kivy.uix.recycleboxlayout import RecycleBoxLayout
from kivy.uix.recycleview.layout import LayoutSelectionBehavior


class SelectableRecycleBoxLayout(
    RecycleBoxLayout, FocusBehavior, LayoutSelectionBehavior
):
    """選択可能な RecycleBoxLayout を定義したクラス"""

    selected_row: RowItem = ObjectProperty(None)
    """選択された行アイテム"""

    def __init__(self, **kwargs):
        """選択可能な RecycleBoxLayout のインスタンスを作成して返す。"""

        super().__init__(**kwargs)
