"""
アクションバーを定義したクラス

    「ロト6 当せん数字予測アプリ」
    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang import Builder
from kivy.properties import ObjectProperty
from kivy.uix.actionbar import ActionBar, ActionButton

Builder.load_string("""
<MyActionBar>:
    write_csv_button: write_csv_button
    main_screen_button: main_screen_button
    ball_set_button: ball_set_button
    occurrence_rate_button: occurrence_rate_button

    ActionView:
        ActionPrevious:
            app_icon: 'image_256.png'
            app_icon_height: dp(32)
            app_icon_width: dp(32)
            on_press: app.root.on_previous_icon_click()
            with_previous: False
        ActionButton:
            id: main_screen_button
            text: 'データ管理画面'
            on_release: app.root.on_main_screen_button_click()
        ActionButton:
            id: ball_set_button
            text: 'セット球情報画面'
            on_release: app.root.on_ball_sets_info_button_click()
        ActionButton:
            id: occurrence_rate_button
            text: 'セット球別集計画面'
            on_release: app.root.on_by_ball_set_button_click()
        ActionButton:
            id: write_csv_button
            text: 'CSV ファイル出力'
            on_release: app.root.on_write_csv_button_click()
""")


class MyActionBar(ActionBar):
    """アクションバーを定義したクラス。"""

    write_csv_button: ActionButton = ObjectProperty(None)
    """「CSV ファイル出力」ボタン"""

    main_screen_button: ActionButton = ObjectProperty(None)
    """「データ管理画面」ボタン"""

    ball_set_button: ActionButton = ObjectProperty(None)
    """「セット球情報画面」ボタン"""

    occurrence_rate_button: ActionButton = ObjectProperty(None)
    """「セット球別集計画面」ボタン"""

    def __init__(self, **kwargs):
        """アクションバーを定義したクラスのインスタンスを作成して返す。"""

        super().__init__(**kwargs)
