"""
メイン画面のデータグリッドのレコード行とヘッダー行の定義

    「ロト6 当せん数字予測アプリ」
    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang.builder import Builder
from kivy.properties import NumericProperty, StringProperty

from datagrid.data_label import DataLabel
from datagrid.header_item import HeaderItem
from datagrid.header_label import HeaderLabel
from datagrid.row_item import RowItem

Builder.load_string("""
<DataGridMainRow>:
    selectable: True

    DataLabel:
        text: str(root.times)
        size_hint_x: 0.12
        text_size: self.size
        halign: 'right'
    DataLabel:
        text: f"{root.first_num :0>2}"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    DataLabel:
        text: f"{root.second_num :0>2}"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    DataLabel:
        text: f"{root.third_num :0>2}"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    DataLabel:
        text: f"{root.fourth_num :0>2}"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    DataLabel:
        text: f"{root.fifth_num :0>2}"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    DataLabel:
        text: f"{root.sixth_num :0>2}"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    DataLabel:
        text: f"{root.bonus_num :0>2}"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    DataLabel:
        text: root.ball_set
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'

<DataGridMainHeader>:
    HeaderLabel:
        text: "抽選回"
        size_hint_x: 0.12
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "第 1"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "第 2"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "第 3"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "第 4"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "第 5"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "第 6"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "ボーナス"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: "セット球"
        size_hint_x: 0.11
        text_size: self.size
        halign: 'center'
""")


class DataGridMainRow(RowItem):
    """メイン画面のデータグリッドのレコード行を定義したクラス"""

    times: int = NumericProperty(0)
    """抽選回"""

    first_num: int = NumericProperty(0)
    """第 1 数字"""

    second_num: int = NumericProperty(0)
    """第 2 数字"""

    third_num: int = NumericProperty(0)
    """第 3 数字"""

    fourth_num: int = NumericProperty(0)
    """第 4 数字"""

    fifth_num: int = NumericProperty(0)
    """第 5 数字"""

    sixth_num: int = NumericProperty(0)
    """第 6 数字"""

    bonus_num: int = NumericProperty(0)
    """ボーナス数字"""

    ball_set: str = StringProperty("")
    """セット球"""


class DataGridMainHeader(HeaderItem):
    """メイン画面のデータグリッドのヘッダー行を定義したクラス"""

    pass
