"""
特定の数字と同時に出現している数字の出現回数のデータグリッドのレコード行とヘッダー行の定義

    「ロト6 当せん数字予測アプリ」
    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang.builder import Builder
from kivy.properties import NumericProperty, StringProperty

from datagrid.data_label import DataLabel
from datagrid.header_item import HeaderItem
from datagrid.header_label import HeaderLabel
from datagrid.row_item import RowItem

Builder.load_string("""
<DataGridCoOccurrenceRow>:
    selectable: False

    DataLabel:
        text: f"{root.numbers :0>2}"
        size_hint_x: 0.3
        text_size: self.size
        halign: 'center'
        current_bg_color: (0.92, 0.92, 1.0, 1.0)
    DataLabel:
        text: str(root.co_occurrence)
        size_hint_x: 0.4
        text_size: self.size
        halign: 'right'
    DataLabel:
        text: str(root.count)
        size_hint_x: 0.3
        text_size: self.size
        halign: 'right'
        
<DataGridCoOccurrenceHeader>:
    HeaderLabel:
        text: root.numbers
        size_hint_x: 0.3
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: root.co_occurrence
        size_hint_x: 0.4
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: root.count
        size_hint_x: 0.3
        text_size: self.size
        halign: 'center'
""")


class DataGridCoOccurrenceRow(RowItem):
    """特定の数字と同時に出現している数字の出現回数のデータグリッドのレコード行を定義したクラス"""

    numbers: int = NumericProperty(0)
    """数字"""

    co_occurrence: int = NumericProperty(0)
    """特定の数字と同時に出現している数字の出現回数"""

    count: int = NumericProperty(0)
    """数字の出現回数"""


class DataGridCoOccurrenceHeader(HeaderItem):
    """特定の数字と同時に出現している数字の出現回数のデータグリッドのヘッダー行を定義したクラス"""

    numbers: str = StringProperty("数字")
    """数字"""

    co_occurrence: str = StringProperty("同時出現回数")
    """特定の数字と同時に出現している数字の出現回数"""

    count: str = StringProperty("出現回数")
    """数字の出現回数"""
