"""
セット球の選出状況のデータグリッドのレコード行とヘッダー行の定義

    「ロト6 当せん数字予測アプリ」
    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang.builder import Builder
from kivy.properties import NumericProperty, StringProperty

from datagrid.data_label import DataLabel
from datagrid.header_item import HeaderItem
from datagrid.header_label import HeaderLabel
from datagrid.row_item import RowItem

Builder.load_string("""
<DataGridBallSetsRow>:
    selectable: False

    DataLabel:
        text: root.ball_set
        size_hint_x: 0.34
        text_size: self.size
        halign: 'center'
        current_bg_color: (0.92, 0.92, 1.0, 1.0)
    DataLabel:
        text: str(root.count)
        size_hint_x: 0.33
        text_size: self.size
        halign: 'right'
    DataLabel:
        text: f"{root.rate :.1%}"
        size_hint_x: 0.33
        text_size: self.size
        halign: 'right'
        
<DataGridBallSetsHeader>:
    HeaderLabel:
        text: root.ball_set
        size_hint_x: 0.34
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: root.count
        size_hint_x: 0.33
        text_size: self.size
        halign: 'center'
    HeaderLabel:
        text: root.rate
        size_hint_x: 0.33
        text_size: self.size
        halign: 'center'
""")


class DataGridBallSetsRow(RowItem):
    """セット球の選出状況のデータグリッドのレコード行を定義したクラス"""

    ball_set: str = StringProperty("")
    """セット球の名称"""

    count: int = NumericProperty(0)
    """セット球の選出回数"""

    rate: float = NumericProperty(0.0)
    """セット球の選出率"""


class DataGridBallSetsHeader(HeaderItem):
    """セット球の選出状況のデータグリッドのヘッダー行を定義したクラス"""

    ball_set: str = StringProperty("セット球")
    """セット球の名称"""

    count: str = StringProperty("選出回数")
    """セット球の選出回数"""

    rate: str = StringProperty("選出率")
    """セット球の選出率"""
