"""
HeaderItem クラスのインスタンスに配置するラベルの定義

    Last modified: 2025/06/24

    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang import Builder
from kivy.uix.label import Label

Builder.load_string("""
<HeaderLabel>:
    color: (0.0, 0.0, 0.0, 1.0)
    text_size: self.size
    valign: 'center'
    halign: 'center'
    canvas.before:
        Color:
            rgba: (180/255, 180/255, 180/255, 1.0)
        Rectangle:
            pos: self.pos
            size: self.size
        Color:
            rgba: (0.5, 0.5, 0.5, 1.0)
        Line:
            rectangle: (self.x+1, self.y+1, self.width, self.height)
            width: 1.0
""")


class HeaderLabel(Label):
    """HeaderItem クラスのインスタンスに配置するラベルを定義したクラス"""

    def __init__(self, **kwargs):
        """HeaderItem クラスのインスタンスに配置するラベルのインスタンスを作成して返す。"""

        super().__init__(**kwargs)
