"""
RowItem クラスのインスタンスに配置するラベルの定義

    Last modified: 2025/06/24

    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang import Builder
from kivy.properties import BooleanProperty, ListProperty
from kivy.uix.label import Label

Builder.load_string("""
<DataLabel>:
    color: root.current_text_color
    text_size: self.size
    valign: 'center'
    padding: dp(4), 0
    canvas.before:
        Color:
            rgba: root.current_bg_color
        Rectangle:
            pos: self.pos
            size: self.size
        Color:
            rgba: (0.5, 0.5, 0.5, 1.0)
        Line:
            rectangle: (self.x+1, self.y+1, self.width, self.height)
            width: 1.0
""")


class DataLabel(Label):
    """RowItem クラスのインスタンスに配置するラベルを定義したクラス"""

    is_selected: bool = BooleanProperty(False)
    """選択されていれば True"""

    default_bg_color: list[float] = ListProperty([1.0, 1.0, 1.0, 1.0])
    """選択されていないときの背景色"""

    selected_bg_color: list[float] = ListProperty([0.2, 0.2, 0.9, 1.0])
    """選択されたときの背景色"""

    default_text_color: list[float] = ListProperty([0.0, 0.0, 0.0, 1.0])
    """選択されていないときの文字色"""

    selected_text_color: list[float] = ListProperty([1.0, 1.0, 1.0, 1.0])
    """選択されたときの文字色"""

    current_bg_color: list[float] = ListProperty([1.0, 1.0, 1.0, 1.0])
    """現在の背景色"""

    current_text_color: list[float] = ListProperty([0.0, 0.0, 0.0, 1.0])
    """現在の文字色"""

    def __init__(self, **kwargs):
        """RowItem クラスのインスタンスに配置するラベルのインスタンスを作成して返す。"""

        super().__init__(**kwargs)

        self.bind(is_selected=self._change_color)  # type: ignore

    def _change_color(self, instance, value) -> None:
        """文字色および背景色を変更する。

        Args:
            instance (DataLabel): DataLabel のインスタンス。
            value (bool): 選択状態。
        """

        if self.is_selected:
            self.current_bg_color = self.selected_bg_color
            self.current_text_color = self.selected_text_color
        else:
            self.current_bg_color = self.default_bg_color
            self.current_text_color = self.default_text_color
