"""
PyInstaller の Windows 用 SPEC ファイル

Usage:
    pyinstaller --log-level=INFO LOTO6_Analyzer_win.spec

    「ロト6 当せん数字予測アプリ」
    Copyright (c) 2025 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

# -*- mode: python ; coding: utf-8 -*-

from kivy_deps import sdl2, glew    # 追記

block_cipher = None


a = Analysis(
    ['main.py'],
    pathex=[],
    binaries=[],
    datas=[
        ('./LICENSE.TXT', '.'),
        ('./VLGothic/VL-PGothic-Regular.ttf','./VLGothic'),
        ('./images','./images'),
        ('./my_dialogs/images','./my_dialogs/images'),
    ],
    hiddenimports=['win32file', 'win32timezone'],   # 追記
    hookspath=[],
    hooksconfig={},
    runtime_hooks=[],
    excludes=[],
    win_no_prefer_redirects=False,
    win_private_assemblies=False,
    cipher=block_cipher,
    noarchive=False,
)
pyz = PYZ(a.pure, a.zipped_data, cipher=block_cipher)

exe = EXE(
    pyz,
    a.scripts,
    a.binaries,
    a.zipfiles,
    a.datas,
    *[Tree(p) for p in (sdl2.dep_bins + glew.dep_bins)],    # 追記
    name='LOTO6_Analyzer',                                  # 変更
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=True,
    upx_exclude=[],
    runtime_tmpdir=None,
    console=False,
    disable_windowed_traceback=False,
    argv_emulation=False,
    target_arch=None,
    codesign_identity=None,
    entitlements_file=None,
    version='file_version_info.txt',    # 追記
    icon=['./images/favicon.ico'],      # 追記
)

# 追記
coll = COLLECT(exe, Tree('.'),
               a.binaries,
               a.zipfiles,
               a.datas,
               *[Tree(p) for p in (sdl2.dep_bins + glew.dep_bins)],
               strip=False,
               upx=True,
               name='LOTO6_Analyzer')   # 変更
