"""
results_screen.kv の RecycleView の viewclass に設定するクラス。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.uix.boxlayout import BoxLayout


class Record(BoxLayout):
    """results_screen.kv の RecycleView の viewclass に設定するクラス。"""

    def __init__(self, **kwargs) -> None:
        """RecycleView の viewclass に設定するクラスのインスタンスを作成して返す。"""

        super().__init__(**kwargs)

    def get_display_value(self, value: int, play_count: int) -> str:
        """対戦成績画面に表示するデータを整形して返す。

        Args:
            value (int): 表示する値。
            play_count (int): プレイ回数。

        Returns:
            str: 表示する値。
        """

        rate: float = 0.0 if (play_count == 0) else (value / play_count)

        return f"{value:,} ({rate:.1%})"
