"""
プレイヤーの状態を表示するウィジェットの定義。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang.builder import Builder
from kivy.properties import ListProperty, StringProperty
from kivy.uix.boxlayout import BoxLayout

Builder.load_string("""
<PlayerStatus>:
    orientation: "horizontal"
    size_hint: 0.34, 0.04
    Label:
        size_hint_x: 0.13
        font_size: dp(14)
        text: root.maker_text
        color: root.maker_text_color
        canvas.before:
            Color:
                rgba: root.marker_bg_color
            Rectangle:
                pos: self.pos
                size: self.size
    Label:
        size_hint_x: 0.2
        font_size: dp(16)
        text: root.name_text
        color: root.name_text_color
    Label:
        color: root.amount_text_color
        size_hint_x: 0.54
        font_size: dp(16)
        text: root.amount_text
        canvas.before:
            Color:
                rgba: root.amount_bg_color
            Rectangle:
                pos: self.pos
                size: self.size
    Label:
        size_hint_x: 0.13
        font_size: dp(14)
        color: root.rank_text_color
        canvas.before:
            Color:
                rgba: root.rank_bg_color
            Rectangle:
                pos: self.pos
                size: self.size
""")


class PlayerStatus(BoxLayout):
    """プレイヤーの状態を表示するウィジェットを定義したクラス。"""

    maker_text: str = StringProperty("")
    """マーカーの文字列"""

    maker_text_color: list[float] = ListProperty([0.0, 0.0, 0.0, 1.0])
    """マーカーの文字色"""

    marker_bg_color: list[float] = ListProperty([0.0, 0.0, 0.0, 0.0])
    """マーカーの背景色"""

    name_text: str = StringProperty("")
    """名前の文字列"""

    name_text_color: list[float] = ListProperty([0.0, 0.0, 0.0, 1.0])
    """名前の文字色"""

    amount_text: str = StringProperty("")
    """貯水量の文字列"""

    amount_text_color: list[float] = ListProperty([0.0, 0.0, 0.0, 1.0])
    """貯水量の文字色"""

    amount_bg_color: list[float] = ListProperty([0.0, 0.0, 0.0, 0.0])
    """貯水量の背景色"""

    rank_text: str = StringProperty("")
    """順位の文字列"""

    rank_text_color: list[float] = ListProperty([0.0, 0.0, 0.0, 0.0])
    """順位の文字色"""

    rank_bg_color: list[float] = ListProperty([0.0, 0.0, 0.0, 0.0])
    """順位の背景色"""

    def __init__(self, **kwargs):
        """プレイヤーの状態を表示するウィジェットを定義したクラスのインスタンスを作成して返す。"""

        super().__init__(**kwargs)
