"""
画像を描画する自作ウィジェットの定義。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from kivy.lang.builder import Builder
from kivy.properties import NumericProperty, StringProperty
from kivy.uix.widget import Widget

Builder.load_string("""
<CustomImage>:
    size_hint: None, None
    canvas:
        Rectangle:
            source: self.source
            pos: self.pos
            size: self.size
""")


class CustomImage(Widget):
    """
    画像を描画する自作ウィジェットを定義したクラス。
    オリジナルの Image ウィジェットを Python コードで動的に配置すると、
    collide_point() メソッドに反応する範囲が広くなってしまうため、自作した。
    """

    source: str = StringProperty("")
    """画像のパス"""

    name: str = StringProperty("")
    """画像の名前"""

    index: int = NumericProperty(0)
    """インデックス番号"""

    def __init__(self, **kwargs):
        """画像を描画する自作ウィジェットを定義したクラスのインスタンスを作成して返す。"""

        super().__init__(**kwargs)
