"""
手札の状況を取得する関数群。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from models.card import Card
from models.card_type import CardType


def has_specified_card(cards: list[Card], card_types: list[CardType]) -> bool:
    """手札の中に、指定された種類のいずれかのカードがあれば True を返す。

    Args:
        cards (list[Card]): 手札の list。
        card_types (list[CardType]): 対象となるカードの種類。

    Returns:
        bool: 手札の中に、指定された種類のいずれかのカードがあれば True。
    """

    return any([c for c in cards if (c.type in card_types)])


def has_specific_cards_more_than(
    cards: list[Card], card_types: list[CardType], count: int
) -> bool:
    """手札の中に、指定された種類のカードが指定された枚数以上あれば True を返す。

    Args:
        cards (list[Card]): 手札の list。
        card_types (list[CardType]): 対象となるカードの種類。
        count (int): 対象となるカードの枚数。

    Returns:
        bool: 手札の中に、指定された種類のカードが、合計で指定された枚数以上あれば True。
    """

    target: list[Card] = [c for c in cards if c.type in card_types]

    return len(target) >= count
