"""
アプリ内で共有する変数を管理する。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from dataclasses import dataclass, field

from kivy.core.audio import Sound

from models.game_scene import GameScene
from models.sound_scene import SoundScene


@dataclass(slots=True)
class SharedVars:
    """アプリ内で共有する変数を管理するクラス。"""

    game_scene: GameScene = GameScene.TITLE
    """現在のゲームシーン（画面）"""

    prev_scene: GameScene = GameScene.TITLE
    """ひとつ前のゲームシーン（画面）"""

    sounds: dict[SoundScene, Sound] = field(default_factory=dict)
    """BGM / 効果音のインスタンスの dict。"""
