"""
ゲームの設定値等を管理する。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from dataclasses import dataclass, field

import constants
from models.difficulty import Difficulty


@dataclass(slots=True)
class MyConfig:
    """ゲームの設定値等を管理するクラス。"""

    player_count: int = 6
    """プレイ人数"""

    difficulty: Difficulty = Difficulty.NORMAL
    """難易度"""

    bgm_volume: int = 8
    """BGM の音量（誤差対策のため 100 倍した整数値）"""

    add_option_cards: bool = False
    """オプションのカードを追加する場合は True"""

    results: list[constants.ResultDict] = field(default_factory=list)
    """対戦成績データ"""
