"""
ゲームシーン（場面）の定義。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from enum import IntEnum, auto


class GameScene(IntEnum):
    """ゲームシーン（場面）の定義。"""

    TITLE = auto()
    """タイトル画面"""

    MENU = auto()
    """メニュー画面"""

    VERSION = auto()
    """バージョン情報画面"""

    EXCHANGE_CARDS = auto()
    """交換するカードの選択中"""

    TURN_OF_COMPUTER = auto()
    """コンピュータープレイヤーの順番"""

    TURN_OF_HUMAN = auto()
    """人間プレイヤーの順番"""

    ENTERING_RELEASE = auto()
    """放流量の入力中"""

    DISPLAY_CARDS = auto()
    """カード一覧画面"""

    GAME_END = auto()
    """ゲーム終了"""

    DISPLAY_RESULTS = auto()
    """対戦成績表示画面"""
