"""
ゲームの難易度の定義。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from enum import IntEnum


class Difficulty(IntEnum):
    """ゲームの難易度の定義。"""

    NORMAL = 0
    """ふつう"""

    HARD = 1
    """ちょいムズ"""

    def get_mode_name(self, player_count: int) -> str:
        """プレイ人数と難易度から、ゲームのモード名（日本語）を返す。

        Args:
            player_count (int): プレイ人数。

        Returns:
            str: ゲームのモード名（日本語）。
        """

        text: str = "／ふつう" if (self == Difficulty.NORMAL) else "／ちょいムズ"
        text = text if player_count > 2 else ""
        return f"{player_count}人{text}"
