"""
カードの情報を管理する。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from dataclasses import dataclass

from models.affected_player import AffectedPlayer
from models.affected_target import AffectedTarget
from models.card_type import CardType
from views.custom_image import CustomImage


@dataclass(slots=True)
class Card:
    """カードの情報を管理するクラス。"""

    type: CardType
    """カードの種類"""

    index: int
    """インデックス番号"""

    widget: CustomImage
    """カードを表示するためのウィジェット"""

    name: str
    """カードの名前"""

    affected_player: AffectedPlayer
    """影響を受けるプレイヤー"""

    affected_target: AffectedTarget
    """影響を受ける項目"""

    water_increase_amount: int
    """貯水量の増加量"""

    draw_count: int
    """山札から引くカードの枚数"""

    description: str
    """カードの説明"""

    is_selected: bool
    """交換するカードとして選択されている場合は True"""
