"""
出されたカードの影響を受けるプレイヤーの定義。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from enum import Enum, auto


class AffectedPlayer(Enum):
    """出されたカードの影響を受けるプレイヤーの定義。"""

    NONE = auto()
    """定義なし"""

    ALL_PLAYERS = auto()
    """全員"""

    NEXT_PLAYER = auto()
    """次の順番のプレイヤー"""

    PLAYER_WITH_MOST_WATER = auto()
    """貯水量が最多のプレイヤー"""

    PLAYER_WITH_LOWEST_WATER = auto()
    """貯水量が最少のプレイヤー"""

    SELF = auto()
    """自分"""
