"""
アプリ内で共有する定数

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from typing import TypedDict

PRODUCT_NAME: str = "だむぽん！"
"""このアプリの名前"""

VERSION: str = "2.1.4.1"
"""このアプリのバージョン番号"""

COPYRIGHT: str = "Copyright © 2022 toshifumi tsutsui"
"""このアプリの著作権"""

CONF_FILE_PATH: str = "./config.json"
"""設定ファイルのパス"""

LOG_DIR_PATH: str = "./logs"
"""ログファイルの出力先のパス"""

BASE_NAME: str = "Dampon"
"""このアプリがビルドされたときのファイル名（拡張子除く）"""

CARDS_TO_DEAL_COUNT: int = 5
"""最初に各プレイヤーに配るカードの枚数"""

WATER_STORAGE_AT_START: int = 3
"""開始時点の貯水量（× 100万）"""

WATER_CAPACITY: int = 15
"""貯水量の最大量（× 100万）"""


class ResultDict(TypedDict):
    """対戦成績データの型ヒント"""

    row: str
    mode: str
    play_count: int
    win_count: int
    draw_count: int
    dropout_count: int


INITIAL_RESULTS: list[ResultDict] = [
    {
        "row": "odd",
        "mode": "2人",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "even",
        "mode": "3人／ふつう",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "odd",
        "mode": "3人／ちょいムズ",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "even",
        "mode": "4人／ふつう",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "odd",
        "mode": "4人／ちょいムズ",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "even",
        "mode": "5人／ふつう",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "odd",
        "mode": "5人／ちょいムズ",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "even",
        "mode": "6人／ふつう",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
    {
        "row": "odd",
        "mode": "6人／ちょいムズ",
        "play_count": 0,
        "win_count": 0,
        "draw_count": 0,
        "dropout_count": 0,
    },
]
"""対戦成績データの初期値"""
