"""
コンピューターが操作するプレイヤーの交換する手札の選択に関する戦術。

    「だむぽん！」
    Copyright © 2022 toshifumi tsutsui
    Released under the MIT license
    https://wpandora8.net/the_mit_license.html
"""

from models.card import Card
from models.card_type import CardType


def leave_target_cards(
    cards: list[Card], cards_to_leave: dict[CardType, int]
) -> list[Card]:
    """手札のうち、指定された種類のカードを指定された枚数だけ残して、
    残りを選択状態にした手札の list を返す。

    Args:
        cards (list[Card]): 手札の list。
        cards_to_leave (dict[CardType, int]): 手元に残すカードの種類とその枚数のペア。

    Returns:
        list[Card]: 手札の list。
    """

    for card in cards:
        card.is_selected = True

    for type in cards_to_leave.keys():
        num: int = cards_to_leave[type]
        ext_cards: list[Card] = [c for c in cards if c.type == type][0:num]

        for card in ext_cards:
            card.is_selected = False

    return cards
